#include "map.h"
static MapRender mr;
void map_render(void) {
    Application * a = app();
    land_font_set(a->font);
    float zoom = game->viewport->zoom;
    land_reset_transform();
    land_scale(zoom, zoom);
    if (mr.current != game->level) {
        mr.current = game->level;
        mr.l = mr.current;
        mr.count = 0;
    }
    else {
        mr.l++;
        if (mr.l == 50) {
            mr.l = 1;
        }
    }
    float w = 960;
    int i = game->level /* want to draw it last */;
    for (int i2 = 1; i2 < 50; i2 += 1) {
        int x, z;
        i++;
        if (i > 49) {
            i = 1;
        }
        if (i == mr.l && mr.count < 49) {
            //print("save_check(%d)", i)
            save_check(i);
            mr.count++;
        }
        game_level_number_to_xz(i, & x, & z);
        float sx, sy;
        // a level is 960
        float ls = 960.0 / 7 /* level scale */;
        project(game->viewport, (x - 3) * ls, 0, (z - 3) * ls, & sx, & sy);
        land_color(0.5, 0.5, 0.5, 1);
        float s = w / 14;
        float xy [8] = {sx, sy - s / 2, sx + s, sy, sx, sy + s / 2, sx - s, sy};
        land_polygon(4, xy);
        if (! save_is_saved(i)) {
            if (i != game->level) {
                land_text_pos(sx, sy);
                land_print_middle("?");
                continue;
            }
        }
        //land_color(0, 0, 0, 1)
        //land_polygon(4, xy)
        //int dx[4] = {-1, 1, 0, 0}
        //int dz[4] = {0, 0, -1, 1}
        //for int j in range(4):
        //if mr.si[i].exits[j]:
        //s = w / 72
        //float ex, ey
        //project(game.viewport, (x - 3 + dx[j] * 0.5) * ls, 0,
        //(z - 3 + dz[j] * 0.5) * ls, &ex, &ey)
        //float xy3[8] = {ex, ey - s / 2, ex + s, ey, ex, ey + s / 2,
        //ex - s, ey}
        //if game.level == i:
        //float c = (land_get_ticks() / 15) % 2
        //land_premul(1, c, c, 1)
        //else:
        //land_premul(1, 1, 1, 1)
        //land_filled_polygon(4, xy3)
        //land_color(0, 0, 0, 1)
        //if dx[j] != 0:
        //land_line(xy3[0], xy3[1], xy3[2], xy3[3])
        //land_line(xy3[4], xy3[5], xy3[6], xy3[7])
        //else:
        //land_line(xy3[2], xy3[3], xy3[4], xy3[5])
        //land_line(xy3[6], xy3[7], xy3[0], xy3[1])
        land_push_transform();
        land_translate(sx, sy);
        land_scale(1.0 / 9, 1.0 / 9);
        int n = save_get_level_n(i);
        // each polygon has 14 vertices
        for (int bi = 0; bi < n; bi += 14) {
            float * bxy = save_get_level_xy(i) + bi;
            if (game->level == i) {
                float c = (land_get_ticks() / 15) % 2;
                land_premul(c, c, c, c);
            }
            else {
                land_premul(1, 1, 1, 1);
            }
            land_filled_polygon(6, bxy);
        }
        //land_color(0, 0, 0, 1)
        //land_polygon(6, bxy)
        land_pop_transform();
    }
    int x = 4;
    int y = game->viewport->y + 960 / 7;
    land_text_pos(x, y);
    land_color(1, 1, 1, 1);
    land_print("deaths per minute chart");
    for (int m = 0; m < 30; m += 1) {
        int d = game->deaths_per_minute [29 - m];
        int maxh = 10 * 10;
        int h = d * 10;
        if (d == 0) {
            land_color(1, 1, 1, 1);
        }
        else {
            land_color(1, 0, 0, 1);
        }
        land_filled_rectangle(x + 10 * m + 2, y + maxh, x + 10 * m + 8, y + maxh - 3 - h);
        land_text_pos(x + 10 * m + 5, y + maxh + 2);
        land_print_center("%d", d);
    }
    x = 960 - 4;
    land_text_pos(960 - 4, y);
    land_color(1, 1, 1, 1);
    land_print_right("percentage completed");
    x -= 30 * 10;
    for (int m = 0; m < 30; m += 1) {
        int l = game->levels_in_minute [29 - m];
        int maxh = 100;
        int h = l * maxh / 49;
        land_color(1, 1, 1, 1);
        land_filled_rectangle(x + 10 * m + 2, y + maxh, x + 10 * m + 8, y + maxh - 3 - h);
        if (m % 5 == 4) {
            land_line(x + 10 * m + 5, y + maxh, x + 10 * m + 5, y + maxh + 4);
            land_text_pos(0, 0);
            land_push_transform();
            land_translate(x + 10 * m, y + maxh + 2 + 12);
            land_rotate(- pi / 4);
            land_print_middle("%d%%", 100 * l / 49);
            land_pop_transform();
        }
    }
}
